class xSetup expands Mutator config(xSetup);

//HUD imports:
#exec TEXTURE IMPORT NAME=Warning FILE=Textures\Warning.bmp LODSET=2
#exec TEXTURE IMPORT NAME=TeamScores FILE=Textures\TeamScores.bmp LODSET=2

//SB imports:
#exec TEXTURE IMPORT NAME=WhiteDot FILE=Textures\WhiteDot.bmp LODSET=2
#exec TEXTURE IMPORT NAME=SBLogo FILE=Textures\Scoreboard.bmp LODSET=2
#exec TEXTURE IMPORT NAME=FadeA FILE=Textures\FadeA.bmp LODSET=2
#exec TEXTURE IMPORT NAME=FadeB FILE=Textures\FadeB.bmp LODSET=2
#exec TEXTURE IMPORT NAME=IsisTaylor FILE=Textures\IsisTaylor.bmp LODSET=2
#exec TEXTURE IMPORT NAME=JenniferWhite FILE=Textures\JenniferWhite.bmp LODSET=2
#exec TEXTURE IMPORT NAME=KaydenKross FILE=Textures\KaydenKross.bmp LODSET=2
#exec TEXTURE IMPORT NAME=KristinaRose FILE=Textures\KristinaRose.bmp LODSET=2
#exec TEXTURE IMPORT NAME=SunnyLeone FILE=Textures\SunnyLeone.bmp LODSET=2
#exec TEXTURE IMPORT NAME=ToriBlack FILE=Textures\ToriBlack.bmp LODSET=2
#exec TEXTURE IMPORT NAME=AlettaOcean FILE=Textures\AlettaOcean.bmp LODSET=2
#exec TEXTURE IMPORT NAME=AlexisTexas FILE=Textures\AlexisTexas.bmp LODSET=2
#exec TEXTURE IMPORT NAME=BellaMoretti FILE=Textures\BellaMoretti.bmp LODSET=2
#exec TEXTURE IMPORT NAME=BibiJones FILE=Textures\BibiJones.bmp LODSET=2
#exec TEXTURE IMPORT NAME=BreanneBenson FILE=Textures\BreanneBenson.bmp LODSET=2
#exec TEXTURE IMPORT NAME=JaydenJaymes FILE=Textures\JaydenJaymes.bmp LODSET=2
#exec TEXTURE IMPORT NAME=JennaHaze FILE=Textures\JennaHaze.bmp LODSET=2
#exec TEXTURE IMPORT NAME=JennaPresley FILE=Textures\JennaPresley.bmp LODSET=2
#exec TEXTURE IMPORT NAME=JuelzVentura FILE=Textures\JuelzVentura.bmp LODSET=2
#exec TEXTURE IMPORT NAME=JynxMaze FILE=Textures\JynxMaze.bmp LODSET=2
#exec TEXTURE IMPORT NAME=KagneyLinnKarter FILE=Textures\KagneyLinnKarter.bmp LODSET=2
#exec TEXTURE IMPORT NAME=Katsuni FILE=Textures\Katsuni.bmp LODSET=2
#exec TEXTURE IMPORT NAME=MadelynMarie FILE=Textures\MadelynMarie.bmp LODSET=2
#exec TEXTURE IMPORT NAME=MoniqueAlexander FILE=Textures\MoniqueAlexander.bmp LODSET=2
#exec TEXTURE IMPORT NAME=PriyaRai FILE=Textures\PriyaRai.bmp LODSET=2
#exec TEXTURE IMPORT NAME=SophiaSanti FILE=Textures\SophiaSanti.bmp LODSET=2
#exec TEXTURE IMPORT NAME=Stoya FILE=Textures\Stoya.bmp LODSET=2

//Relic Texture imports:
#exec TEXTURE IMPORT NAME=IconDefense FILE=Textures\IconDefense.bmp LODSET=2
#exec TEXTURE IMPORT NAME=IconRedemption FILE=Textures\IconRedemption.bmp LODSET=2
#exec TEXTURE IMPORT NAME=IconRegen FILE=Textures\IconRegen.bmp LODSET=2
#exec TEXTURE IMPORT NAME=IconSpeed FILE=Textures\IconSpeed.bmp LODSET=2
#exec TEXTURE IMPORT NAME=IconStrength FILE=Textures\IconStrength.bmp LODSET=2
#exec TEXTURE IMPORT NAME=IconVengeance FILE=Textures\IconVengeance.bmp LODSET=2

//Import CP ring mesh:
#exec mesh import mesh=TheRing anivfile=Models\TheRing_a.3d datafile=Models\TheRing_d.3d x=0 y=0 z=0 mlod=0
#exec mesh origin mesh=TheRing x=0 y=0 z=0
#exec mesh sequence mesh=TheRing seq=All startframe=0 numframes=1
#exec meshmap new meshmap=TheRing mesh=TheRing
#exec meshmap scale meshmap=TheRing x=0.09375 y=0.09375 z=0.18750

//Import Domination Babe Textures:
#exec TEXTURE IMPORT NAME=BabeNA FILE=Textures\BabeNA.bmp LODSET=2
#exec TEXTURE IMPORT NAME=BabeRed FILE=Textures\BabeRed.bmp LODSET=2
#exec TEXTURE IMPORT NAME=BabeBlue FILE=Textures\BabeBlue.bmp LODSET=2

//Import Textures for CTF flags:
#exec TEXTURE IMPORT NAME=RedBabeFlagA FILE=Textures\RedFlagA.bmp LODSET=2
#exec TEXTURE IMPORT NAME=BlueBabeFlagA FILE=Textures\BlueFlagA.bmp LODSET=2
#exec TEXTURE IMPORT NAME=RedBabeFlagB FILE=Textures\RedFlagB.bmp LODSET=2
#exec TEXTURE IMPORT NAME=BlueBabeFlagB FILE=Textures\BlueFlagB.bmp LODSET=2
#exec TEXTURE IMPORT NAME=RedBabeFlagC FILE=Textures\RedFlagC.bmp LODSET=2
#exec TEXTURE IMPORT NAME=BlueBabeFlagC FILE=Textures\BlueFlagC.bmp LODSET=2

//Import Weapon & Ammo Textures:
#exec TEXTURE IMPORT NAME=BukkakeGunSkinA FILE=Textures\BukkakeGunSkinA.bmp group="Skins" LODSET=2
#exec TEXTURE IMPORT NAME=BukkakeGunSkinB FILE=Textures\BukkakeGunSkinB.bmp group="Skins" LODSET=2
#exec TEXTURE IMPORT NAME=BukkakeGunSkinC FILE=Textures\BukkakeGunSkinC.bmp group="Skins" LODSET=2
#exec TEXTURE IMPORT NAME=BukkakeCrateA FILE=Textures\BukkakeCrateA.bmp group="Skins" LODSET=2
#exec TEXTURE IMPORT NAME=BukkakeCrateB FILE=Textures\BukkakeCrateB.bmp group="Skins" LODSET=2
#exec TEXTURE IMPORT NAME=GooGunSkinA FILE=Textures\GooGunSkinA.bmp group="Skins" LODSET=2
#exec TEXTURE IMPORT NAME=GooGunSkinB FILE=Textures\GooGunSkinB.bmp group="Skins" LODSET=2
#exec TEXTURE IMPORT NAME=Goo  FILE=Textures\Goo.bmp GROUP="Skins" MIPS=ON

// GameName vars
var config string 	DMName,
					TDMName,
					CTFName,
					DOMName;

// LeftMessage vars
var config string 	LeftMessage,
					EnteredMessage;

function PreBeginPlay ()
{
	Super.PreBeginPlay();
	
	SaveConfig();
	
	Level.Game.LeftMessage = LeftMessage;
	Level.Game.EnteredMessage = EnteredMessage;
	
	AddMutator(Level.Spawn(class'RelicControl'));
	AddMutator(Level.Spawn(class'StatisticMut'));
	
	switch (Level.Game.Default.GameName)
		{
		case "Tournament DeathMatch":
			Level.Game.HUDType = Class'DM_HUD';
			Level.Game.ScoreBoardType = Class'DM_SB';
			Level.Game.GameName = DMName;
			break;
		case "Tournament Team Game":
			Level.Game.HUDType = Class'TDM_HUD';
			Level.Game.ScoreBoardType = Class'TDM_SB';
			Level.Game.GameName = TDMName;
			break;
		case "Capture the Flag":
			Level.Game.HUDType = Class'CTF_HUD';
			Level.Game.ScoreBoardType = Class'CTF_SB';
			Level.Game.GameName = CTFName;
			AddMutator(Level.Spawn(class'xCTFmut'));
			break;
		case "Domination":
			Level.Game.HUDType = Class'DOM_HUD';
			Level.Game.ScoreBoardType = Class'DOM_SB';
			Level.Game.GameName = DOMName;
			SetTimer(0.1,True);
			SpawnGirlMeshes();
			break;
		default:
		return;
		}
}



function bool AlwaysKeep(Actor Other)
{
	if ( Other.IsA('Carcass') )
		{
		Carcass(Other).Style = STY_Translucent;
		Carcass(Other).bProjTarget = False;
		Carcass(Other).bBlockPlayers = False;
		}
	if ( Other.IsA('PlayerPawn') )
        {
		PlayerPawn(Other).PlayerReplicationInfoClass = class'PRI';
		return true;
		}
	
	if ( NextMutator != None )
		return ( NextMutator.AlwaysKeep(Other) );
	
	return false;
}

function SpawnGirlMeshes()
{
local NavigationPoint NP;
local Babe B;

	for (NP = Level.NavigationPointList; NP != None; NP = NP.NextNavigationPoint)
		{
		if ( NP.IsA('ControlPoint'))
			{
			B = Spawn(Class'Babe',,,NP.Location+Vect(0,0,4));
			B.MultiSkins[0] = Texture'BabeNA';
			B.Mother = NP;
			}
		}
}

function Timer()
{
local NavigationPoint NP;
local TeamGamePlus T;
local Babe B;

	T = TeamGamePlus(Level.Game);

	ForEach AllActors(class'Babe', B)
		{
		if ( B.IsA('Babe'))
			{
			if ( B.Mother != none )
				{
				if ( ControlPoint(B.Mother).Controller.PlayerReplicationInfo.Team == T.TEAM_Red )
					{
					B.MultiSkins[0] = Texture'BabeRed';
					}
				else if ( ControlPoint(B.Mother).Controller.PlayerReplicationInfo.Team == T.TEAM_Blue )
					{
					B.MultiSkins[0] = Texture'BabeBlue';
					}
				}
			}
		}
	
	for (NP = Level.NavigationPointList; NP != None; NP = NP.NextNavigationPoint)
		{
		if ( NP.IsA('ControlPoint'))
			{
			NP.Mesh = Mesh'TheRing';
			NP.DrawScale = 1.2;
			NP.bMeshEnviroMap = True;
			NP.RotationRate.Roll = 15500;
			NP.RotationRate.Pitch = 22250;
			NP.RotationRate.Yaw = 18000;

			if ( ControlPoint(NP).ControllingTeam == None )
				{
				NP.Texture = Texture'Botpack.Skins.jlightbox';
				NP.LightHue=255;
				}
			else
				{	
				if ( ControlPoint(NP).Controller.PlayerReplicationInfo.Team == T.TEAM_Red )
					{
					NP.Texture = FireTexture'UnrealShare.Belt_fx.ShieldBelt.Redshield';
					NP.LightHue=0;
					}
				else if ( ControlPoint(NP).Controller.PlayerReplicationInfo.Team == T.TEAM_Blue )
					{
					NP.Texture = FireTexture'UnrealShare.Belt_fx.ShieldBelt.Blueshield';
					NP.LightHue=170;
					}
				}
			}
		}
	
}

defaultproperties
{
     DMName="Adult UT DeathMatch"
     TDMName="Adult UT Team DeathMatch"
     CTFName="Adult UT Capture The Flag"
     DOMName="Adult UT Domination"
     LeftMessage=" left the game, QUITER!!"
     EnteredMessage=" joined the game, a new target yeah!"
}
